// File: TNeural.h
//
// Description: This is the header file for the
//              TNeuralNet C++ class.  This class
//              provides both back propagation
//              training and runtime modules.
//
// Copyright 1991, 1994 by Mark Watson. 
//

#ifndef __TNeuralNet
#define __TNeuralNet

#include "applib.h"

#include "double_v.h"

class TNeuralNet {

  public:

    // Utility methods:
    void forward_pass(double *inputs);
    void backwards_error_pass(double *inputs,
                              double *target_outputs);

    // Constructor for a net with a 1 dimensional input:
    TNeuralNet(int input_size, int hidden_size, int output_size);
    
    // Constructor for a net with a 2 dimensional
    // input: use a 1 D neural net and linearize
    // the 2 D input vector.
    
    // Utility for training:
    double auto_train(int max_iterations,int num_samples,
                      double *packed_inputs,
                      double *packed_outputs);
    
    // Runtime utilities:
    void recall(double *input_pattern,
                double *output_classification_vector);
    
    ~TNeuralNet();
    void save(char *filename);
    void restore(char *filename);

    // output neuron calculated activation values
    double *output_activations;

 private:

    // Storage to hold the size of a neural net instance:
    int input_size;
    int hidden_size;
    int output_size;
    
    // Pointers to storage for activation energies:
    double *input_activations;  // input values
    double *hidden_activations; // hidden neuron calculated
                                // activation values
    
    // Pointers to temporary storage for calculating
    // sum-of-product terms for hidden and output neurons:
    double *hidden_sums;
    double *output_sums;
    
    // Pointers to storage for weights connecting the
    // input to hidden neurons and the hidden to output
    // neurons:
    double *w1; // logically dimensioned [input_size][hidden_size]
    double *w2; // logically dimensioned [hidden_size][output_size]
    
    // Pointers to storage for accumulated errors
    double *hidden_errors;
    double *output_errors;
    
    // Number of training examples stored in memory:
    int num_training_examples;
    
    // Pointers to "packed" input and output training data:
    // (e.g., if num_train_examples is 100, and input_size
    // is 10 neurons, then there will be 100*10=1000 input
    // training examples)
    double *input_samples;
    double *output_samples;
    
};

#endif
